/*
 * BasicConfigurator.cpp
 *
 * Copyright 2002, Log4cpp Project. All rights reserved.
 *
 * See the COPYING file for the terms of usage and distribution.
 */
#include "PortabilityImpl.hh"

#ifdef _MSC_VER
#    pragma warning( disable : 4702 ) //unreachable code in STL for VC71
#endif

#ifdef LOG4CPP_HAVE_IO_H
#    include <io.h>
#endif
#ifdef LOG4CPP_HAVE_UNISTD_H
#    include <unistd.h>
#endif

#if defined(VXWORKS)
#    include <ioLib.h>
#    define _dup dup
#    define _fileno fileno
#endif

#ifndef WIN32
#    define _dup    dup
#    define _fileno fileno
#endif

#include <cstdio>
#include <log4cpp/BasicConfigurator.hh>
#include <log4cpp/Category.hh>
#include <log4cpp/FileAppender.hh>
#include <log4cpp/Priority.hh>

LOG4CPP_NS_BEGIN

void BasicConfigurator::configure() {
    Category& root = Category::getRoot();
    root.setPriority(Priority::INFO);
    root.removeAllAppenders();
    root.addAppender(new FileAppender("_", _dup(_fileno(stdout))));
}

LOG4CPP_NS_END




