/*
 * BasicLayout.cpp
 *
 * Copyright 2000, LifeLine Networks BV (www.lifeline.nl). All rights reserved.
 * Copyright 2000, Bastiaan Bakker. All rights reserved.
 *
 * See the COPYING file for the terms of usage and distribution.
 */
#ifdef _MSC_VER
#   pragma warning( disable : 4702 ) //unreachable code in STL for VC71
#endif

#include "PortabilityImpl.hh"
#include <log4cpp/BasicLayout.hh>
#include <log4cpp/Priority.hh>
#include <log4cpp/FactoryParams.hh>
#include <memory>

#ifdef LOG4CPP_HAVE_SSTREAM
#include <sstream>
#endif

LOG4CPP_NS_BEGIN

BasicLayout::BasicLayout() {
}

BasicLayout::~BasicLayout() {
}

std::string BasicLayout::format(const LoggingEvent& event) {
    std::ostringstream message;

    const std::string& priorityName = Priority::getPriorityName(event.priority);
    message << event.timeStamp.getSeconds() << " " << priorityName << " "
        << event.categoryName << " " << event.ndc << ": "
        << event.message << std::endl;

    return message.str();
}

std::auto_ptr<Layout> create_basic_layout(const FactoryParams& /*params*/)
{
    return std::auto_ptr<Layout>(new BasicLayout);
}
LOG4CPP_NS_END

