//-----------------------------------------------------------------------------
//  (c) 2005 by Basler Vision Technologies
//  Section: Vision Components
//  Project: GenApi
//  Author:  Fritz Dierks
//  $Header$
//-----------------------------------------------------------------------------
/*!
\file
\brief    Helper function
*/

#include <log4cpp/Extensions/Utilities.h>
#include <stdlib.h>

LOG4CPP_NS_BEGIN
bool ReplaceEnvironmentVariables(std::string &Buffer)
{
#if defined(UNDER_RTSS)
    UNREFERENCED_PARAMETER(Buffer);
#if _DEBUG
    printf("Could not get Environment variables\n");
#endif // _DEBUG
    return false;
#else
    using namespace std;
    std::string str = Buffer;

    string::size_type pVariableBegin, pVariableEnd;
    pVariableBegin = str.find("$(");
    while (string::npos != pVariableBegin)
    {
        pVariableEnd = str.find_first_of(")", pVariableBegin);
        if (string::npos == pVariableEnd)
            break;

        string VariableName = str.substr(pVariableBegin + 2, pVariableEnd - pVariableBegin - 2);

#if defined( _WIN32)
        char pVariableContent[256];
        DWORD res = GetEnvironmentVariable(VariableName.c_str(), pVariableContent, 256);
        if (res == 0 || res == 256)
            return false;

#else
        char *pVariableContent;
        pVariableContent = getenv(VariableName.c_str());
        if (NULL == pVariableContent)
            return false;
#endif

        string VariableContent(pVariableContent);
        str.replace(pVariableBegin, pVariableEnd - pVariableBegin + 1, VariableContent);

        pVariableBegin = str.find("$(", pVariableEnd);

    }
    Buffer = str;
    return true;
#endif // defined(UNDER_RTSS)
}

#if 0
bool ReplaceEnvironmentVariables(std::string &Buffer)
{
    using namespace std;

    string _Buffer = Buffer;
    string::size_type pVariableBegin, pVariableEnd;

    pVariableBegin = _Buffer.find_first_of("$(", 0);
    while(string::npos != pVariableBegin)
    {
        pVariableEnd = _Buffer.find_first_of(")", pVariableBegin);
        if(string::npos == pVariableEnd)
            break;

        string VariableName = _Buffer.substr(pVariableBegin+2, pVariableEnd-2);

        char pVariableContent[256];
        DWORD res = GetEnvironmentVariable(VariableName.c_str(), pVariableContent, 256);
        if(res == 0 || res == 256)
            return false;

        string VariableContent(pVariableContent);
        _Buffer.replace(pVariableBegin, pVariableEnd-pVariableBegin+1, VariableContent);

        pVariableBegin = _Buffer.find_first_of("$(", pVariableEnd);
    }
    Buffer = _Buffer;
    return true;
}
#endif
LOG4CPP_NS_END

